unit Unit1;

interface

{$IFDEF WIN32}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WpWinCtr, WPRich, WPRuler, ExtCtrls, WPTbar, StdCtrls, WPPrTab1, WPTxtDef,
  Buttons, WPDefs, WPStatus, Wpstat2;
{$ELSE}
uses
  WinProcs, WinTypes, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WpWinCtr, WPRich, WPRuler, ExtCtrls, WPTbar, StdCtrls, WPPrTab1, WPTxtDef,
  Buttons, WPDefs, WPStatus, Wpstat2;
{$ENDIF}

type
  TForm1 = class(TForm)
    WPRichText1: TWPRichText;
    Panel1: TPanel;
    Textlines: TButton;
    Table1: TButton;
    StatusBar: TWPAltStatusBar;
    procedure Button3Click(Sender: TObject);
    procedure TextlinesClick(Sender: TObject);
    procedure Table1Click(Sender: TObject);
  private
    { Private-Deklarationen }
      TransBuf : array[0..256] of Char;
  public
    { Public-Deklarationen }
    FSpeedMerge : Boolean;
    FTotal      : Longint;
    FInpCount   : Integer;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button3Click(Sender: TObject);
var
  prp : TParProps;
  Aprp : array[0..5] of TParProps;  { declared in unit WPtxtDef }
  i   : Integer;
  j,a   : Integer;
begin
  FillChar(Aprp[0],Sizeof(TParProps)*6,0);
  for i:=0 to 5 do
  begin
    Aprp[i].Attr := WPRichText1.Attr;
    Aprp[i].BorderType.LineType := [blEnabled,blBox];
    Aprp[i].text := 'Cell ' + IntToStr(i);
  end;

  include(Aprp[5].Attr.Style,afsIsInsertPoint);
  Aprp[5].text := '#';

  FillChar(prp,Sizeof(TParProps),0);
  prp.Attr := WPRichText1.Attr;
  j := 0;

  WPRichText1.Clear;
  try
    for a:=0 to 10 do
    begin
       prp.Attr.Height := 20;
       prp.Text := '';
       WPRichText1.FastAddText(prp);
       prp.Text := 'An now the data '+IntToStr(j)+' to '+IntToStr(j+100);
       WPRichText1.FastAddText(prp);
       prp.Text := '';
       WPRichText1.FastAddText(prp);
       for i:=1 to 100 do
       begin
        Aprp[5].Attr.tag := j;

        Aprp[0].Attr.Color := i mod 15;
        Aprp[0].Text := 'Row ' + IntToStr(j);
        WPRichText1.FastAddTable(6,@(Aprp[0]));
        inc(j);
       end;
    end;
  finally
  WPRichText1.Refresh;
  end;
end;

{ Called to get Text.
  Never call Repaint, Reformat or similar within GetTextToInsert !!! }
procedure TForm1.TextlinesClick(Sender: TObject);
var
  prp : TParProps;  { declared in unit WPtxtDef }
  i   : Integer;
begin
  StatusBar.GaugeReset;
  StatusBar.GaugeRestrictSub(60);
  StatusBar.GaugeIn(2000);
  StatusBar.SetString(stStatus,'adding');
  FillChar(prp,Sizeof(TParProps),0);
  prp.Attr := WPRichText1.Attr;
  WPRichText1.Clear;
  for i:=0 to 2000 do
  begin
     prp.Attr.Color := i mod 15;
     prp.Text := 'Line ' + IntToStr(i);
     WPRichText1.FastAddText(prp);
     StatusBar.GaugeInc(i);
  end;
  StatusBar.SetString(stStatus,'format');
  WPRichText1.Refresh;
  StatusBar.SetString(stStatus,' ');
  StatusBar.GaugeOut;
  StatusBar.GaugeReset;
end;

procedure TForm1.Table1Click(Sender: TObject);
var
  prp : TParProps;
  Aprp : array[0..5] of TParProps;  { declared in unit WPtxtDef }
  i   : Integer;
  j,a   : Integer;
begin
  FillChar(Aprp[0],Sizeof(TParProps)*6,0);
  for i:=0 to 5 do
  begin
    Aprp[i].Attr := WPRichText1.Attr;
    Aprp[i].BorderType.LineType := [blEnabled,blBox];
    Aprp[i].text := 'Cell ' + IntToStr(i);
  end;

  FillChar(prp,Sizeof(TParProps),0);
  prp.Attr := WPRichText1.Attr;
  j := 0;

  WPRichText1.Clear;
  try
    for a:=1 to 10 do
    begin
       StatusBar.GaugeValue := a*10;
       prp.Attr.Height := 20;
       prp.NewPage := TRUE;

       prp.Text := 'And now the data from '+IntToStr(j)+' to '+IntToStr(j+100);
       prp.NewPage := TRUE;
       WPRichText1.FastAddText(prp);
       prp.NewPage := FALSE;
       prp.Text := '';
       WPRichText1.FastAddText(prp);
       for i:=1 to 50 do
       begin
        Aprp[5].Attr.tag := j;

        Aprp[0].Attr.Color := i mod 15;
        Aprp[0].Text := 'Row ' + IntToStr(j);
        WPRichText1.FastAddTable(6,@(Aprp[0]));
        inc(j);
       end;
       prp.Text := '';
       WPRichText1.FastAddText(prp);
    end;
  finally
  StatusBar.GaugeValue := 0;
  WPRichText1.Refresh;
  end;
end;

end.
